﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Workflow.Runtime;
using System.Workflow.Runtime.Hosting;


/*  
    Workflow parameters.
 
 
    Passing initialization parameters to a workflow when starting the workflow.
    Getting back public property values of a workflow upon completion.
 */
namespace Lessons.Workflows
{
    class Program
    {
        static void Main(string[] args)
        {

            using (WorkflowRuntime workflowRuntime = new WorkflowRuntime())
            {
                AutoResetEvent waitHandle = new AutoResetEvent(false);


                workflowRuntime.WorkflowCompleted += delegate(object sender, WorkflowCompletedEventArgs e)
                {
                    /* accessing a public property of the workflow by name, after workflow completion */
                    string S = (string)e.OutputParameters["Param"];
                    Console.WriteLine(S);

                    waitHandle.Set();             
                };


                workflowRuntime.WorkflowTerminated += delegate(object sender, WorkflowTerminatedEventArgs e)
                {
                    Console.WriteLine(e.Exception.Message);
                    waitHandle.Set();
                };


                /* a Dictionary object is used to pass any number and type of parameters to the workflow. 
                   The key of each dictionary entry must be the name of a public property of the workflow.
                   The Param here is a public property of the Workflow1 */
                Dictionary<string, object> Params = new Dictionary<string, object>();
                Params["Param"] = "Hi there";
                //Params.Add("Param", "Hi there");    


                WorkflowInstance instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1), Params);
                instance.Start();

                waitHandle.WaitOne();

                Console.WriteLine("Hit <ENTER> key to exit");
                Console.ReadLine();
            }
        }
    }
}
